#version 330
#extension GL_EXT_gpu_shader4 : enable
// Collapsing WavesMod01.fsh  by  KilledByAPixel 

//https://www.shadertoy.com/view/MlXyWM
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//////////////////////////////////////////////////////////////////////////////////
// Canyon Trip Zoom - Copyright 2017 Frank Force
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
//////////////////////////////////////////////////////////////////////////////////

const float zoomSpeed			= -3.0;	// how fast to zoom (negative to zoom out)
const float zoomScale			= 1.0;	// how much to multiply overall zoom (closer to zero zooms in)
const int recursionCount		= 8;	// how deep to recurse
const float curvature			= 0.3;	// time warp to add curvature

//////////////////////////////////////////////////////////////////////////////////
// Precached values and math

const float e = 2.718281828459;
const float pi = 3.14159265359;
float RandFloat(int i) { return (fract(sin(float(i)) * 43758.5453)); }
int RandInt(int i) { return int(100000.0*RandFloat(i)); }

vec4 HsvToRgb(vec4 c) 
{
    float s = c.y * c.z;
    float s_n = c.z - s * .5;
    return vec4(s_n) + vec4(s) * cos(2.0 * pi * (c.x + vec4(1.0, 0.6666, .3333, 0.0)));
}

//////////////////////////////////////////////////////////////////////////////////
// Color and image manipulation

float GetRecursionFade(int r, float timePercent)
{
    if (r > recursionCount)
        return timePercent;
    
    // fade in and out recusion
    float rt = max(float(r) - timePercent, 0.0);
    float rc = float(recursionCount);
    return rt / rc;
}

vec4 InitPixelColor() { return vec4(0); }
vec4 CombinePixelColor(vec4 color, float timePercent, int i, int r)
{
    vec4 myColor = vec4
    (
 /*   	mix(-0.1, 0.1, RandFloat(i + r)),
    	mix(0.0, 0.8, RandFloat(i + r + 100)),
        mix(0.0, 0.8, RandFloat(i + r + 200)),
        0.0
*/
        mix(0.8, 0.5, RandFloat(i + r)),
    	mix(0.3, 0.85, RandFloat(i + r + 200)),
        mix(0.25, 0.9, RandFloat(i + r + 300)),
        0.0


    );

    // combine with my color
    float f = GetRecursionFade(r, timePercent);
    myColor.y = pow(myColor.y, 4.0);
    myColor.z = pow(myColor.z, 4.0);
    color += myColor*f;
    return color;
}

vec4 FinishPixel(vec4 color, vec2 uv)
{
    // color wander
    color.x += 0.02*iTime;
    
    // convert to rgb
    return HsvToRgb(color);
}

vec2 InitUV(vec2 uv)
{
	// wave
	uv.x += 0.05*sin(10.0*uv.y + 0.17*iTime);
	uv.y += 0.05*sin(10.0*uv.x + 0.13*iTime);
	uv.x += 0.8*sin(2.0*uv.y + 0.31*iTime);
	uv.y += 0.8*sin(2.0*uv.x + 0.27*iTime);
    
    // spin
    float theta = 0.05*iTime;
    float c = cos(theta);
    float s = sin(theta);
    uv *= mat2(-s, c, c, s);
    
    return uv * 20.0;
}
 
//////////////////////////////////////////////////////////////////////////////////
void main (void)	
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	// use square aspect ratio
	vec2 uv = gl_FragCoord.xy;
	uv = gl_FragCoord.xy / iResolution.y;
	uv -= vec2(0.5*iResolution.x / iResolution.y, 0.5);
    uv = InitUV(uv);
    
	// get time 
    float time = iTime + curvature*pow(abs(uv.x), 1.0);
	float timePercent = time*zoomSpeed;
	int iterations = int(floor(timePercent));
	timePercent -= float(iterations);
	
	// update zoom, apply pow to make rate constant
	float zoom = pow(e, -timePercent);
	zoom *= zoomScale;
	
	// generate recursive colors
	gl_FragColor = InitPixelColor();
	for (int r = 0; r <= recursionCount + 1; ++r)
        gl_FragColor = CombinePixelColor(gl_FragColor, timePercent, iterations, r);
    gl_FragColor = FinishPixel(gl_FragColor, uv);
}
